/*--------------------------------------
    imain.c

    Mark & Marc,  5/31/93 12:51:50
    contains the gateway calls communicating with the shell
*/

#include "icon.h"

extern EventRecordPtr fEventPtr;
extern word fUserID;
extern long remHelpID;

word			    edResFileID, shResFileID, fdResFileID;
word                isInitCurs;
word                mod;
handle              toolIcn[6];
handle              cursor[6];

word REM_OPEN(fOpenRecPtr p)
{
word			retErr;
long			sizeH, tempID;
Handle		    title, ctlH, resData;
privateDataHndl	privH;
privateDataPtr  privP;
GrafPortPtr		winP;

	if (p->resType != rIcon) {
        if (p->resType != rBundle) {
            if (p->resType != rCursor) {
		        return resInvalidTypeOrID;
            }
        }
    }

    tempID = p->resType + 0x10000L;

	if (!p->resID || (p->fFlag & (F_OPENSILENT | F_OPENDATA))) {
		if (p->fFlag & F_OPENDATA)
			resData = p->Data;
		else {
            resData = fLoadResource2(p->resType, tempID, 0L, edResFileID, 0L);
			fDetachResource2(p->resType, tempID, edResFileID);
		}

        p->resID = fAddResource2(p->resType, p->resID, resData, 0, 0, 0L);

		fReleaseResource2(p->resType, p->resID, 0);

		if (p->fFlag & F_OPENSILENT)
			return 0;
	}

    privH = (privateDataHndl) NewHandle(PRIVATESIZE, fUserID, 0x0018, 0L);
    privP = *privH;

    if (p->resType == rCursor)
	    tempID = 0x18001L;  /* pretend it's an icon */


	privP->winTempH = loadEdRes(tempID, rWindParam1);
	winP = NewWindow2(0L, 0L, 0L, 0L, 1, privP->winTempH, rWindParam1);
    SetTitle(winP, p->resID);
	SetPort(winP);
	SetFrameColor(p->wColorPtr, winP);

    fAddPrivateData2(winP, 0L, 0, (Handle) privH, 0x0020, p->resType, p->resID);

    privP->resData = fLoadResource2(p->resType, p->resID, 0L, 0, 0L);
	privP->resID = p->resID;
	privP->resType = p->resType;

    switch (p->resType) {
    case rIcon:
    case rCursor:
        retErr = iconOpen(privP, winP);
        break;
    case rBundle:
        retErr = openBundle(privP, winP);
        break;
    }
	return  0;
}

word REM_CLOSE(fCloseRecPtr p) {

word			retErr;
handle		    txtData;
long			txtLength;
long            tempID;
GrafPortPtr		winP;
privateDataHndl	privH;
privateDataPtr  privP;

	winP = (GrafPortPtr) p->windowPtr;
	privH = (privateDataHndl) fGetPrivateData2(winP, 0L, 0L);
    privP = *privH;

	checkData(winP);

	CloseWindow(winP);

	fReleaseResource2(p->resType, p->resID, 0);

    if (p->resType != rBundle) {
	    tempID = 0x18001L;
    	unloadEdRes(tempID, rWindParam1);
    }
	if (p->resType != rBundle) {
		DisposeHandle(privP->resData);
		DisposeHandle(privP->winTitle);
		DisposeHandle((Handle) privP->editH);
		DisposeHandle((Handle) privP->undoH);
        DisposeHandle((Handle) privP->imageCache);
        DisposeHandle((Handle) privP->maskCache);
		DisposeHandle((Handle) privH);
	}
	else {
		/* dispose of bundle handles */
	}
    InitCursor();
	return  0;
}

word REM_WRITE(fCloseRecPtr p) {

handle		    txtData;
long			txtLength;
GrafPortPtr		winP;
privateDataHndl	private;
word			retErr;

	winP = (GrafPortPtr) p->windowPtr;
	checkData(winP);
	return 0;
}

word REM_EVENT(fEventRecPtr p) {

word			retErr;
privateDataHndl	privH;
privateDataPtr  privP;
GrafPortPtr		winP, oldP;
Rect            icn, msk;
RegionHndl      theRegion;
Point           pt;
word            inImage;
word            inMask;
word            tool;

    tool = 0;
    oldP = GetPort();
	switch (p->taskCode) {
        case nullEvt:
	        winP = FrontWindow();
            theRegion = GetContentRgn(winP);
    	    privH = (privateDataHndl) fGetPrivateData2(winP, 0L, 0L);
            privP = *privH;
            pt.h = fEventPtr->where.h;
            pt.v = fEventPtr->where.v;
            StartDrawing(winP);
            GlobalToLocal(&pt);
            inImage = PtInRect(&pt, &privP->fatIRect);
            inMask  = PtInRect(&pt, &privP->fatMRect);

            if (inImage || inMask) {
                drawCoords(privP, pt.h, pt.v, inMask);
                if (privP->tool & 0x8000) {
                    privP->tool &= 0x0007;
                    if (!tool)
                        tool = privP->tool;
                    SetCursor(*cursor[tool]);
                    isInitCurs = 0;
                }
            }
            else if (!isInitCurs) {
                InitCursor();
                isInitCurs = -1;
                privP->tool |= 0x8000;
            }
            break;

		case updateEvt:
			retErr = UpdateEditor((GrafPortPtr) fEventPtr->wmTaskData);
			break;

		case wInInfo:
		    retErr = InEditorInfo(fEventPtr);
			break;

		case wInContent:
            if (p->resType != rBundle)
			    FatClick(fEventPtr);
			else {
				/*   HandleBundle(fEventPtr);   */
            }
			break;

        case wInSpecial:
		case wInMenuBar:
            if (p->resType != rBundle)
				retErr = EditorMenu(fEventPtr);
/*			else           this code not supported till bundle is real
				retErr = BundleMenu(fEventPtr);     */
			break;

		case app3Evt:
	        winP = (GrafPortPtr) fEventPtr->wmTaskData;
            SetTitle(winP, p->resID);
			break;

		default:
			break;
	}
	return 0;
}

word REM_ACTIVATE(fActivateRecPtr p)
{
handle		    txtData;
GrafPortPtr		oldP, winP;
long			txtLength;
privateDataHndl	privH;
privateDataPtr	privP;
RegionHndl      theRegion;

	winP = (GrafPortPtr) fEventPtr->wmTaskData;
	if (p->fFlag & F_ACTIVATE) {
        privH = (privateDataHndl) fGetPrivateData2(winP, 0L, 0L);
        privP = *privH;
        oldP = GetPort();
        SetPort(winP);
        MakeGlobalRect(&privP->fatIRect, &privP->gFatIRect);
        MakeGlobalRect(&privP->fatMRect, &privP->gFatMRect);
        MakeGlobalRect(&privP->sizeRect, &privP->gSizeRect);
        SetPort(oldP);

        privP->tool |= 0x8000;
        InitCursor();
        isInitCurs = -1;
		p->fFlag |= (F_UNDO + F_CLIP + F_CLEAR + F_MENUAPPLY);
    }
	else {
		checkData(winP);
		InitCursor();
        isInitCurs = 0;
	}
	return  0;
}

word REM_GETLINK(fLinkRecPtr p) {

	return 0;		/*  The shell knows all about us...  */
}

word REM_VIDMODE(fVidModeRecPtr p) {

GrafPortPtr		winP;
privateDataHndl	privH;

	if (p->resType != rBundle) {
		(pointer) winP = p->windowPtr;
		privH = (privateDataHndl) fGetPrivateData2(winP, 0L, 0L);
		SetWindowSize(*privH);
	}
	SetFrameColor(p->wColorPtr, winP);
	return 0;
}

word REM_PRINT(fCloseRecPtr p) {

	return 0;				/* no printing in this version */
}

word REM_STARTUP(fStartStopRecPtr p)
{
word    i;

	fUserID = p->edUserID;
	edResFileID = p->edResFileID;
	shResFileID = p->shResFileID;
	fdResFileID = p->fdResFileID;

    for (i = 0; i < 6; i++) {
        toolIcn[i] = loadEdRes(i + 1, rIcon);
        cursor[i] = loadEdRes(i + 1, rCursor);
    }
	return  0;
}

word REM_SHUTDOWN(fStartStopRecPtr p)
{
word    i;

    for (i = 0; i < 6; i++) {
        unloadEdRes(i + 1, rIcon);
        unloadEdRes(i + 1, rCursor);
    }
	DisposeAll(fUserID);
	return 0;
}
